/////////////////////////////////////////////////////////////
//	File	:	"IBaseInterface.h"
//
//	Author	:	David Brown (DB)
//
//	Purpose	:	Defines a set of functions that EVERY object
//				that inherits from the class MUST implement.
/////////////////////////////////////////////////////////////

#pragma once

#include "Debug.h"

class IBaseInterface
{
public:
	virtual ~IBaseInterface(void) = 0 {}
	virtual void Update(float fElapsedTime) = 0;
	virtual void Render(void) = 0;

	virtual void AddRef(void) = 0; // Will you be my myspace friend?
	virtual void Release(void) = 0;// I'm movin' bai!

};